//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Threading;
using System.IO;
using System.Security;
using System.Security.Permissions;

namespace ProfilingSamples
{
	public class SecurityAttributesMain 
	{
		[FileIOPermissionAttribute(SecurityAction.LinkDemand, Unrestricted=true)]
		public static void CopyFile(String srcPath, String dstPath) 
		{
			// W pozostaej czci metody dania odczytu pliku rdowego i dania
			// zapisu pliku docelowego bd przydzielane natychmiast. Sprawdzanie
			// dalszej czci stosu nie jest wymagane.

			FileInfo srcFile = new FileInfo(srcPath);
			FileInfo dstFile = new FileInfo(dstPath);
			Stream src = srcFile.Open(FileMode.Open, FileAccess.Read, FileShare.Read);
			Stream dst = dstFile.Open(FileMode.Create, FileAccess.Write, FileShare.None);
			if (srcFile.Length > Int32.MaxValue)
				throw new Exception("CopyFile wymaga, aby wielko pliku rdowego nie przekraczaa 2 GB.");
			Byte[] buffer = new Byte[(Int32) srcFile.Length];
			src.Read(buffer, 0, (Int32) srcFile.Length);
			dst.Write(buffer, 0, (Int32) srcFile.Length);
			//dstFile.CreationTime   = srcFile.CreationTime;
			//dstFile.LastAccessTime = srcFile.LastAccessTime;
			//dstFile.LastWriteTime  = srcFile.LastWriteTime;
			src.Close();
			dst.Close();
		}
		void RecurseSecurityCheck(int i)
		{
			if(i > 0)
				RecurseSecurityCheck(i - 1);
			else
			{
				CopyFile(".\\Security.exe", ".\\Security.copy.exe");
			}
		}
		void TestThread()
		{
			try
			{
				while(true)
				{
					RecurseSecurityCheck(50);
					Thread.Sleep(100);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: ", e.Message);
			}
		}
		static void Main(string [] args)
		{
			SecurityAttributesMain m = new SecurityAttributesMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}